﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using UnityEngine;

//Mission is a base abstract class for all missions
public abstract class Mission
{
    public Constants.MissionDifficulties SelectedDifficulty { get; protected set; } = Constants.MissionDifficulties.Sentinel;
    public Vector3Int MissionSpawnPosition { get; private set; }

    public bool IsGenerated { get; protected set; }

    protected bool _IsMissionStarted;

    private float _CarMaxSpeed;    //We need to do this in the constructor, as we can't do GetComponent in Generate as it's on a separate thread

    public Mission(Vector3Int missionSpawnPos)
    {
        MissionSpawnPosition = missionSpawnPos;
        _CarMaxSpeed = GameManager.Instance.PlayerCarGameObject.GetComponent<CarController>().MaxSpeed;
    }

    public abstract bool Generate();

    public abstract void StartMission(Constants.MissionDifficulties difficulty);

    public abstract void EndMission(bool passed);

    /// <summary>
    /// Gets the reward text to display in the UI when the mission passes
    /// </summary>
    /// <returns>The reward text to display</returns>
    public abstract string GetRewardText();

    public abstract void SpawnMinimapIcon(string iconID);

    public abstract void Update();

    /// <summary>
    /// Generates a time for a mission to travel between two points based on the selected difficulty
    /// </summary>
    /// <param name="config">The configuration for the selected difficulty</param>
    /// <param name="originPos">The starting position</param>
    /// <param name="destPos">The destination position</param>
    /// <returns></returns>
    protected int GenerateTimeForDifficulty(MissionsTimeDifficultyConfiguration config, Vector3Int originPos, Vector3Int destPos)
    {
        List<PathNode> nodes = Pathfinder.FindPath(originPos, destPos);
        int baseTime = nodes.Count * config.BaseRoadTime;

        float diffRatio = _CarMaxSpeed / ConfigurationManager.Instance.Missions.Core.Time.BaseSpeed;
        float timeRatio = diffRatio / config.SpeedTimeRatio;

        return Convert.ToInt32(baseTime * timeRatio);
    }
}